/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TephradermSpellDamageTriggeredAbility
extends TriggeredAbilityImpl {
    TephradermSpellDamageTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(0));
    }

    private TephradermSpellDamageTriggeredAbility(TephradermSpellDamageTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        StackObject sourceSpell = game.getStack().getStackObject(event.getSourceId());
        if (sourceSpell != null && StaticFilters.FILTER_SPELL.match(sourceSpell, this.getControllerId(), (Ability)this, game)) {
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof DamageTargetEffect)) continue;
                effect.setTargetPointer((TargetPointer)new FixedTarget(sourceSpell.getControllerId()));
                ((DamageTargetEffect)effect).setAmount((DynamicValue)StaticValue.get((int)event.getAmount()));
            }
            return true;
        }
        return false;
    }

    public TephradermSpellDamageTriggeredAbility copy() {
        return new TephradermSpellDamageTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a spell deals damage to {this}, {this} deals that much damage to that spell's controller.";
    }
}

