/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TargetsDamageTargetsEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetOpponentsCreaturePermanent;

public final class TerrificTeamUp
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("you control a permanent with mana value 4 or greater");
    private static final Condition condition;
    private static final Hint hint;

    public TerrificTeamUp(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{G}");
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2, condition));
        ability.setRuleAtTheTop(true);
        ability.addHint(hint);
        this.addAbility((Ability)ability);
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 0));
        this.getSpellAbility().addEffect((Effect)new TargetsDamageTargetsEffect(false));
        this.getSpellAbility().addTarget(new TargetControlledCreaturePermanent(1, 2).setTargetTag(1).withChooseHint("boost and deal damage"));
        this.getSpellAbility().addTarget((Target)new TargetOpponentsCreaturePermanent().setTargetTag(3));
    }

    private TerrificTeamUp(TerrificTeamUp card) {
        super((CardImpl)card);
    }

    public TerrificTeamUp copy() {
        return new TerrificTeamUp(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_GREATER, 4));
        condition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)filter);
        hint = new ConditionHint(condition, "You control a permanent with mana value 4 or greater");
    }
}

