/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;

class TerritoryCullerEffect
extends OneShotEffect {
    TerritoryCullerEffect() {
        super(Outcome.DrawCard);
        this.staticText = "look at the top card of your library. If it's a creature card, you may reveal it and put it into your hand. If you don't put the card into your hand, you may put it into your graveyard";
    }

    private TerritoryCullerEffect(TerritoryCullerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerritoryCullerEffect copy() {
        return new TerritoryCullerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String message;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.lookAtCards(source, "", (Cards)new CardsImpl(card), game);
        if (card.isCreature(game) && controller.chooseUse(this.outcome, message = "Put " + card.getName() + " " + PutCards.HAND.getMessage(false, false), source, game)) {
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            if (PutCards.HAND.moveCard(controller, card, source, game, "")) {
                return true;
            }
        }
        if (controller.chooseUse(Outcome.Discard, message = "Put " + card.getName() + " " + PutCards.GRAVEYARD.getMessage(false, false), source, game)) {
            PutCards.GRAVEYARD.moveCard(controller, card, source, game, "");
        }
        return true;
    }
}

