/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TerritoryForgeStaticEffect
extends ContinuousEffectImpl {
    TerritoryForgeStaticEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "{this} has all activated abilities of the exiled card";
    }

    private TerritoryForgeStaticEffect(TerritoryForgeStaticEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TerritoryForgeStaticEffect copy() {
        return new TerritoryForgeStaticEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)permanent.getZoneChangeCounter(game));
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        for (Card card : exileZone.getCards(game)) {
            for (Ability ability : card.getAbilities(game)) {
                if (!ability.isActivatedAbility()) continue;
                ActivatedAbility copyAbility = (ActivatedAbility)ability.copy();
                permanent.addAbility((Ability)copyAbility, source.getSourceId(), game, true);
            }
        }
        return true;
    }
}

