/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TetraviteToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.CardUtil;

class TetravusCreateTokensEffect
extends OneShotEffect {
    TetravusCreateTokensEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove any number of +1/+1 counters from {this}. If you do, create that many 1/1 colorless Tetravite artifact creature tokens. They each have flying and \"This creature can't be enchanted.\"";
    }

    private TetravusCreateTokensEffect(TetravusCreateTokensEffect effect) {
        super((OneShotEffect)effect);
    }

    public TetravusCreateTokensEffect copy() {
        return new TetravusCreateTokensEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        int countersToRemove = permanent.getCounters(game).getCount(CounterType.P1P1);
        if (countersToRemove == 0) {
            return false;
        }
        RemoveCountersSourceCost cost = new RemoveCountersSourceCost(CounterType.P1P1.createInstance(countersToRemove = player.getAmount(0, countersToRemove, "Choose an amount of counters to remove", source, game)));
        if (cost.pay(source, game, source, source.getControllerId(), true)) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new TetraviteToken(), countersToRemove);
            effect.apply(game, source);
            Object object = game.getState().getValue(CardUtil.getObjectZoneString((String)"_tokensCreated", (MageObject)permanent, (Game)game));
            HashSet<UUID> tokensCreated = object != null ? (HashSet<UUID>)object : new HashSet<UUID>();
            for (UUID tokenId : effect.getLastAddedTokenIds()) {
                if (tokenId == null) continue;
                tokensCreated.add(tokenId);
            }
            game.getState().setValue(CardUtil.getCardZoneString((String)"_tokensCreated", (UUID)source.getSourceId(), (Game)game), tokensCreated);
        }
        return false;
    }
}

