/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TeveshSzatDoomOfFoolsCommanderEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    TeveshSzatDoomOfFoolsCommanderEffect() {
        super(Outcome.Benefit);
        this.staticText = "Gain control of all commanders. Put all commanders from the command zone onto the battlefield under your control.";
    }

    private TeveshSzatDoomOfFoolsCommanderEffect(TeveshSzatDoomOfFoolsCommanderEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeveshSzatDoomOfFoolsCommanderEffect copy() {
        return new TeveshSzatDoomOfFoolsCommanderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            game.addEffect(new GainControlTargetEffect(Duration.Custom, true).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        HashSet commandersToPut = new HashSet();
        game.getPlayerList().stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEach(player -> commandersToPut.addAll(game.getCommanderCardsFromCommandZone(player, CommanderCardType.COMMANDER_OR_OATHBREAKER)));
        controller.moveCards((Cards)new CardsImpl(commandersToPut), Zone.BATTLEFIELD, source, game);
        return true;
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
    }
}

