/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TezzeretBetrayerOfFleshTypeEffect
extends ContinuousEffectImpl {
    TezzeretBetrayerOfFleshTypeEffect() {
        super(Duration.Custom, Outcome.BecomeCreature);
        this.staticText = "target artifact becomes an artifact creature. If it isn't a Vehicle, it has base power and toughness 4/4";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TezzeretBetrayerOfFleshTypeEffect(TezzeretBetrayerOfFleshTypeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TezzeretBetrayerOfFleshTypeEffect copy() {
        return new TezzeretBetrayerOfFleshTypeEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT, CardType.CREATURE});
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b || permanent.hasSubtype(SubType.VEHICLE, game)) {
                    return false;
                }
                permanent.getPower().setModifiedBaseValue(4);
                permanent.getToughness().setModifiedBaseValue(4);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

