/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TezzeretMasterOfTheBridgeEffect
extends OneShotEffect {
    TezzeretMasterOfTheBridgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to each opponent, where X is the number of artifacts you control. You gain X life";
    }

    private TezzeretMasterOfTheBridgeEffect(TezzeretMasterOfTheBridgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TezzeretMasterOfTheBridgeEffect copy() {
        return new TezzeretMasterOfTheBridgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int artifactCount = new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT).calculate(game, source, (Effect)this);
        new DamagePlayersEffect(artifactCount, TargetController.OPPONENT).apply(game, source);
        player.gainLife(artifactCount, game, source);
        return true;
    }
}

