/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.Targets;

class TheAnimusCopyEffect
extends OneShotEffect {
    TheAnimusCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "Until your next turn, target legendary creature you control becomes a copy of target creature card in exile with a memory counter on it";
    }

    private TheAnimusCopyEffect(TheAnimusCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAnimusCopyEffect copy() {
        return new TheAnimusCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Targets targets = source.getTargets();
        if (targets.size() != 2) {
            return false;
        }
        UUID target1Id = ((Target)source.getTargets().get(0)).getFirstTarget();
        UUID target2Id = ((Target)source.getTargets().get(1)).getFirstTarget();
        if (target2Id == null || target1Id == null) {
            return false;
        }
        Card copyFromPermanent = game.getCard(target2Id);
        if (sourcePermanent == null || copyFromPermanent == null) {
            return false;
        }
        CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)copyFromPermanent.getMainCard(), target1Id);
        game.addEffect((ContinuousEffect)copyEffect, source);
        return true;
    }
}

