/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class TheAnimusEffect
extends OneShotEffect {
    TheAnimusEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target legendary creature card from a graveyard with a memory counter on it";
    }

    private TheAnimusEffect(TheAnimusEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAnimusEffect copy() {
        return new TheAnimusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        if (controller == null || targetId == null) {
            return false;
        }
        Card card = game.getCard(targetId);
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        if (game.getState().getZone(card.getId()) != Zone.EXILED) {
            return true;
        }
        card.addCounters(CounterType.MEMORY.createInstance(), source.getControllerId(), source, game);
        return true;
    }
}

