/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TheBiblioplexEffect
extends OneShotEffect {
    TheBiblioplexEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's an instant or sorcery card, you may reveal it and put it into your hand. If you don't put the card into your hand, you may put it into your graveyard";
    }

    private TheBiblioplexEffect(TheBiblioplexEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBiblioplexEffect copy() {
        return new TheBiblioplexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top of library", card, game);
        if (card.isInstantOrSorcery(game) && player.chooseUse(Outcome.DrawCard, "Reveal that card and put it into your hand?", source, game)) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.moveCards(card, Zone.HAND, source, game);
        } else if (player.chooseUse(Outcome.Discard, "Put that card into your graveyard?", source, game)) {
            player.moveCards(card, Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

