/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.BrainiacToken;
import mage.players.Player;

class TheBigIdeaEffect
extends OneShotEffect {
    TheBigIdeaEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Roll a six-sided die. Create a number of 1/1 red Brainiac creature tokens equal to the result";
    }

    private TheBigIdeaEffect(TheBigIdeaEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBigIdeaEffect copy() {
        return new TheBigIdeaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amount = controller.rollDice(this.outcome, source, game, 6);
        return new BrainiacToken().putOntoBattlefield(amount, game, source, source.getControllerId());
    }
}

