/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheBlackstaffOfWaterdeepEffect
extends ContinuousEffectImpl {
    TheBlackstaffOfWaterdeepEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "another target nontoken artifact you control becomes a 4/4 artifact creature for as long as {this} remains tapped";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TheBlackstaffOfWaterdeepEffect(TheBlackstaffOfWaterdeepEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheBlackstaffOfWaterdeepEffect copy() {
        return new TheBlackstaffOfWaterdeepEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent artifact = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.isTapped() || artifact == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                artifact.addCardType(game, new CardType[]{CardType.ARTIFACT});
                artifact.addCardType(game, new CardType[]{CardType.CREATURE});
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                artifact.getPower().setModifiedBaseValue(4);
                artifact.getToughness().setModifiedBaseValue(4);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }
}

