/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheBloodskyMassacreAbility
extends DelayedTriggeredAbility {
    TheBloodskyMassacreAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false, false);
        this.addEffect((Effect)new LoseLifeSourceControllerEffect(1));
    }

    private TheBloodskyMassacreAbility(TheBloodskyMassacreAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.hasSubtype(SubType.BERSERKER, game);
    }

    public TheBloodskyMassacreAbility copy() {
        return new TheBloodskyMassacreAbility(this);
    }

    public String getRule() {
        return "Whenever a Berserker attacks this turn, you draw a card and you lose 1 life.";
    }
}

