/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;

class TheBloodskyMassacreEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.BERSERKER);

    TheBloodskyMassacreEffect() {
        super(Outcome.Benefit);
        this.staticText = "add {R} for each Berserker you control. Until end of turn, you don't lose this mana as steps and phases end";
    }

    private TheBloodskyMassacreEffect(TheBloodskyMassacreEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBloodskyMassacreEffect copy() {
        return new TheBloodskyMassacreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int berserkers = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        player.getManaPool().addMana(new Mana(ManaType.RED, berserkers), game, source, true);
        return true;
    }
}

