/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class TheBookOfVileDarknessCost
extends CostImpl {
    private static final FilterPermanent filter1 = new FilterControlledArtifactPermanent("artifact you control named Eye of Vecna");
    private static final FilterPermanent filter2 = new FilterControlledArtifactPermanent("artifact you control named Hand of Vecna");

    public TheBookOfVileDarknessCost() {
        this.text = "exile {this} and artifacts you control named Eye of Vecna and Hand of Vecna";
    }

    private TheBookOfVileDarknessCost(TheBookOfVileDarknessCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        Permanent sourcePermanent = ability.getSourcePermanentIfItStillExists(game);
        if (controller == null || sourcePermanent == null) {
            return this.paid;
        }
        Permanent eye = TheBookOfVileDarknessCost.getPermanent(filter1, controller, ability, game);
        if (eye == null) {
            return this.paid;
        }
        Permanent hand = TheBookOfVileDarknessCost.getPermanent(filter2, controller, ability, game);
        if (hand == null) {
            return this.paid;
        }
        controller.moveCards((Cards)new CardsImpl(Arrays.asList(sourcePermanent, eye, hand)), Zone.EXILED, source, game);
        HashSet<MageObjectReference> morSet = new HashSet<MageObjectReference>();
        morSet.add(new MageObjectReference((MageObject)sourcePermanent, game));
        morSet.add(new MageObjectReference((MageObject)eye, game));
        morSet.add(new MageObjectReference((MageObject)hand, game));
        ability.getEffects().setValue("BookEyeHand", morSet);
        this.paid = true;
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return source.getSourcePermanentIfItStillExists(game) != null && game.getBattlefield().count(filter1, source.getControllerId(), source, game) > 0 && game.getBattlefield().count(filter2, source.getControllerId(), source, game) > 0;
    }

    private static Permanent getPermanent(FilterPermanent filter, Player controller, Ability source, Game game) {
        int count = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                return game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().findFirst().orElse(null);
            }
        }
        TargetSacrifice target = new TargetSacrifice(filter);
        controller.choose(Outcome.Sacrifice, (Target)target, source, game);
        return game.getPermanent(target.getFirstTarget());
    }

    public TheBookOfVileDarknessCost copy() {
        return new TheBookOfVileDarknessCost(this);
    }

    static {
        filter1.add((Predicate)new NamePredicate("Eye of Vecna"));
        filter2.add((Predicate)new NamePredicate("Hand of Vecna"));
    }
}

