/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.dynamicvalue.common.ManaValueInGraveyard;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GetEmblemEffect;
import mage.abilities.effects.common.cost.SpellCostReductionForEachSourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.t.TheCapitolineTriadCost;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.HistoricPredicate;
import mage.game.command.Emblem;
import mage.game.command.emblems.TheCapitolineTriadEmblem;

public final class TheCapitolineTriad
extends CardImpl {
    private static final FilterCard filter = new FilterCard("historic card");
    private static final DynamicValue costXValue = new CardsInControllerGraveyardCount(filter);
    private static final DynamicValue manaValueGraveyard = new ManaValueInGraveyard(filter);

    public TheCapitolineTriad(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{10}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.GOD);
        this.subtype.add((Object)SubType.ARTIFICER);
        this.power = new MageInt(7);
        this.toughness = new MageInt(7);
        CardsInControllerGraveyardCount xValue = new CardsInControllerGraveyardCount(filter);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionForEachSourceEffect(1, (DynamicValue)xValue));
        ability.setRuleAtTheTop(true);
        ability.addHint((Hint)new ValueHint("Historic cards in your graveyard", costXValue));
        ability.withFlavorWord("Those Who Came Before");
        this.addAbility((Ability)ability);
        ability = new SimpleActivatedAbility((Effect)new GetEmblemEffect((Emblem)new TheCapitolineTriadEmblem()), (Cost)new TheCapitolineTriadCost());
        ability.addHint((Hint)new ValueHint("Mana value of historic cards in graveyard", manaValueGraveyard));
        this.addAbility((Ability)ability);
    }

    private TheCapitolineTriad(TheCapitolineTriad card) {
        super((CardImpl)card);
    }

    public TheCapitolineTriad copy() {
        return new TheCapitolineTriad(this);
    }

    static {
        filter.add((Predicate)HistoricPredicate.instance);
    }
}

