/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.hint.HintUtils;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.HistoricPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class TheCapitolineTriadTarget
extends TargetCardInYourGraveyard {
    private static final FilterCard filter = new FilterCard("historic cards");

    TheCapitolineTriadTarget() {
        super(1, Integer.MAX_VALUE, filter, true);
    }

    private TheCapitolineTriadTarget(TheCapitolineTriadTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public TheCapitolineTriadTarget copy() {
        return new TheCapitolineTriadTarget(this);
    }

    public boolean isChosen(Game game) {
        return super.isChosen(game) && TheCapitolineTriadTarget.metCondition(this.getTargets(), game);
    }

    public String getMessage(Game game) {
        String text = "Select " + this.targetName;
        int manaValueOfSelection = TheCapitolineTriadTarget.manaValueOfSelection(this.getTargets(), game);
        text = text + " (selected " + this.getTargets().size() + " cards; mana value: ";
        text = text + HintUtils.prepareText((String)(manaValueOfSelection + " of 30"), (Color)(manaValueOfSelection >= 30 ? Color.GREEN : Color.RED));
        text = text + ")";
        return text;
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        if (!super.canChoose(sourceControllerId, source, game)) {
            return false;
        }
        HashSet<UUID> idsToCheck = new HashSet<UUID>();
        idsToCheck.addAll(this.getTargets());
        idsToCheck.addAll(this.possibleTargets(sourceControllerId, source, game));
        return TheCapitolineTriadTarget.metCondition(idsToCheck, game);
    }

    private static int manaValueOfSelection(Collection<UUID> cardsIds, Game game) {
        return cardsIds.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
    }

    private static boolean metCondition(Collection<UUID> cardsIds, Game game) {
        return TheCapitolineTriadTarget.manaValueOfSelection(cardsIds, game) >= 30;
    }

    static {
        filter.add((Predicate)HistoricPredicate.instance);
    }
}

