/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.ChosenNamePredicate;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheCloneSagaDelayedTrigger
extends DelayedTriggeredAbility {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with the chosen name");

    TheCloneSagaDelayedTrigger() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false);
    }

    private TheCloneSagaDelayedTrigger(TheCloneSagaDelayedTrigger ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public TheCloneSagaDelayedTrigger copy() {
        return new TheCloneSagaDelayedTrigger(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((DamagedPlayerEvent)event).isCombatDamage()) {
            Permanent creature = game.getPermanent(event.getSourceId());
            return creature != null && filter.match(creature, this.getControllerId(), (Ability)this, game);
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature with the chosen name deals combat damage to a player this turn, draw a card.";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ChosenNamePredicate.instance);
    }
}

