/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TheEarthCrystalEffect
extends ReplacementEffectImpl {
    TheEarthCrystalEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature, false);
        this.staticText = "if one or more +1/+1 counters would be put on a creature you control, twice that many +1/+1 counters are put on that creature instead";
    }

    private TheEarthCrystalEffect(TheEarthCrystalEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowMultiply((int)event.getAmount(), (int)2), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!CounterType.P1P1.getName().equals(event.getData()) || event.getAmount() < 1) {
            return false;
        }
        Permanent permanent = Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElseGet(() -> game.getPermanentEntering(event.getTargetId()));
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game);
    }

    public TheEarthCrystalEffect copy() {
        return new TheEarthCrystalEffect(this);
    }
}

