/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TheEternalWandererSacrificeEffect
extends OneShotEffect {
    TheEternalWandererSacrificeEffect() {
        super(Outcome.Detriment);
        this.staticText = "For each player, choose a creature that player controls. Each player sacrifices all creatures they control not chosen this way";
    }

    private TheEternalWandererSacrificeEffect(TheEternalWandererSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            HashSet<Permanent> chosenPermanents = new HashSet<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                FilterCreaturePermanent filterCreaturePermanent = new FilterCreaturePermanent("a creature of " + player.getName());
                filterCreaturePermanent.add((Predicate)new ControllerIdPredicate(playerId));
                TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filterCreaturePermanent, true);
                if (!target.canChoose(controller.getId(), source, game)) continue;
                controller.chooseTarget(Outcome.Benefit, (Target)target, source, game);
                Permanent creature = game.getPermanent(target.getFirstTarget());
                if (creature != null) {
                    chosenPermanents.add(creature);
                }
                target.clearChosen();
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, playerId, game)) {
                    if (chosenPermanents.contains(permanent)) continue;
                    permanent.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }

    public TheEternalWandererSacrificeEffect copy() {
        return new TheEternalWandererSacrificeEffect(this);
    }
}

