/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class TheFallenWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> playersAndWalkersDealtDamageThisGame = new HashMap<UUID, Set<UUID>>();

    public TheFallenWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER && event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        Permanent damaged = game.getPermanent(event.getTargetId());
        if (damaged != null && !damaged.isPlaneswalker(game)) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null) {
            return;
        }
        Set<UUID> toAdd = this.playersAndWalkersDealtDamageThisGame.get(event.getSourceId()) == null ? new HashSet<UUID>() : this.playersAndWalkersDealtDamageThisGame.get(event.getSourceId());
        toAdd.add(event.getPlayerId());
        this.playersAndWalkersDealtDamageThisGame.put(event.getSourceId(), toAdd);
    }

    public Set<UUID> getPlayersAndWalkersDealtDamageThisGame(UUID creatureId) {
        return this.playersAndWalkersDealtDamageThisGame.get(creatureId);
    }
}

