/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class TheFourteenthDoctorRevealEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    TheFourteenthDoctorRevealEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top fourteen cards of your library. Put all Doctor cards revealed this way into your graveyard and the rest on the bottom of your library in a random order";
    }

    private TheFourteenthDoctorRevealEffect(TheFourteenthDoctorRevealEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFourteenthDoctorRevealEffect copy() {
        return new TheFourteenthDoctorRevealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 14));
        player.revealCards(source, (Cards)cards, game);
        CardsImpl toGrave = new CardsImpl(cards.getCards(filter, game));
        player.moveCards((Cards)toGrave, Zone.GRAVEYARD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter.add((Predicate)SubType.DOCTOR.getPredicate());
    }
}

