/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class TheFourthDoctorWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> usedFrom = new HashMap<UUID, Set<MageObjectReference>>();

    TheFourthDoctorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if ((event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED) && event.getPlayerId() != null && event.hasApprovingIdentifier(MageIdentifier.TheFourthDoctorWatcher)) {
            this.usedFrom.computeIfAbsent(event.getPlayerId(), k -> new HashSet()).add(event.getApprovingObject().getApprovingMageObjectReference());
        }
    }

    public void reset() {
        super.reset();
        this.usedFrom.clear();
    }

    boolean isAbilityUsed(UUID playerId, MageObjectReference mor) {
        return this.usedFrom.getOrDefault(playerId, Collections.emptySet()).contains(mor);
    }
}

