/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.SaddledSourceThisTurnPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetSacrifice;

class TheGitrogRavenousRideEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature that saddled it this turn");

    TheGitrogRavenousRideEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice a creature that saddled it this turn. If you do, draw X cards, then put up to X land cards from your hand onto the battlefield tapped, where X is the sacrificed creature's power";
    }

    private TheGitrogRavenousRideEffect(TheGitrogRavenousRideEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheGitrogRavenousRideEffect copy() {
        return new TheGitrogRavenousRideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, 1, filter);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        permanent.sacrifice(source, game);
        player.drawCards(power, source, game);
        TargetCardInHand targetCard = new TargetCardInHand(0, power, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        player.choose(this.outcome, player.getHand(), (TargetCard)targetCard, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCard.getTargets());
        player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)SaddledSourceThisTurnPredicate.instance);
    }
}

