/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class TheHorusHeresyDestroyEffect
extends OneShotEffect {
    TheHorusHeresyDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player chooses a creature. Destroy each creature chosen this way";
    }

    private TheHorusHeresyDestroyEffect(TheHorusHeresyDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheHorusHeresyDestroyEffect copy() {
        return new TheHorusHeresyDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game) < 1) {
            return false;
        }
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetCreaturePermanent target = new TargetCreaturePermanent();
            target.withNotTarget(true);
            player.choose(Outcome.DestroyPermanent, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanents.add(permanent);
            game.informPlayers(player.getLogName() + " chooses " + permanent.getLogName());
        }
        for (Permanent permanent : permanents) {
            permanent.destroy(source, game);
        }
        return true;
    }
}

