/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheJollyBalloonManEffect
extends OneShotEffect {
    TheJollyBalloonManEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of another target creature you control, except it's a 1/1 red Balloon creature in addition to its other colors and types and it has flying and haste. Sacrifice it at the beginning of the next end step";
    }

    private TheJollyBalloonManEffect(TheJollyBalloonManEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheJollyBalloonManEffect copy() {
        return new TheJollyBalloonManEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, CardType.CREATURE, true, 1, false, false, null, 1, 1, true);
        effect.setExtraColor(ObjectColor.RED);
        effect.withAdditionalSubType(SubType.BALLOON);
        effect.apply(game, source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

