/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class TheKeyToTheVaultEffect
extends OneShotEffect {
    TheKeyToTheVaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at that many cards from the top of your library. You may exile a nonland card from among them. Put the rest on the bottom of your library in a random order. You may cast the exiled card without paying its mana cost";
    }

    private TheKeyToTheVaultEffect(TheKeyToTheVaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheKeyToTheVaultEffect copy() {
        return new TheKeyToTheVaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int damage = (Integer)this.getValue("damage");
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, damage));
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.moveCards(card, Zone.EXILED, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Card)card);
        return true;
    }
}

