/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;

class TheMasamuneEffect
extends ReplacementEffectImpl {
    TheMasamuneEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature dying causes a triggered ability of this creature or an emblem you own to trigger, that ability triggers an additional time.";
    }

    private TheMasamuneEffect(TheMasamuneEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheMasamuneEffect copy() {
        return new TheMasamuneEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (Optional.ofNullable(event).filter(NumberOfTriggersEvent.class::isInstance).map(NumberOfTriggersEvent.class::cast).map(NumberOfTriggersEvent::getSourceEvent).filter(ZoneChangeEvent.class::isInstance).map(ZoneChangeEvent.class::cast).filter(ZoneChangeEvent::isDiesEvent).map(ZoneChangeEvent::getTarget).map(permanent -> permanent.isCreature(game)).orElse(false) == false) return false;
        if (!source.isControlledBy(event.getPlayerId())) return false;
        if (source.getSourceId().equals(event.getSourceId())) return true;
        if (Optional.ofNullable(event).map(GameEvent::getSourceId).map(arg_0 -> ((Game)game).getEmblem(arg_0)).map(Emblem.class::cast).map(Emblem::getControllerOrOwnerId).map(arg_0 -> ((Ability)source).isControlledBy(arg_0)).orElse(false) == false) return false;
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

