/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class TheMasterFormedAnewExileEffect
extends OneShotEffect {
    TheMasterFormedAnewExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile a creature you control and put a takeover counter on it";
    }

    private TheMasterFormedAnewExileEffect(TheMasterFormedAnewExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMasterFormedAnewExileEffect copy() {
        return new TheMasterFormedAnewExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, 1);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (card != null && Zone.EXILED.match(game.getState().getZone(card.getId()))) {
            card.addCounters(CounterType.TAKEOVER.createInstance(), source, game);
        }
        return true;
    }
}

