/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;

class TheMasterMultipliedEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature tokens you control");

    public TheMasterMultipliedEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Triggered abilities you control can't cause you to sacrifice or exile creature tokens you control";
    }

    private TheMasterMultipliedEffect(TheMasterMultipliedEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TheMasterMultipliedEffect copy() {
        return new TheMasterMultipliedEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SACRIFICE_PERMANENT || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent;
        Player controller = game.getPlayer(source.getControllerId());
        UUID eventSourceControllerId = game.getControllerId(event.getSourceId());
        Permanent permanent = game.getPermanent(event.getTargetId());
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null) {
            return false;
        }
        Ability stackAbility = stackObject.getStackAbility();
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && !(zEvent = (ZoneChangeEvent)event).getToZone().equals((Object)Zone.EXILED)) {
            return false;
        }
        return controller != null && permanent != null && filter.match(permanent, source.getControllerId(), source, game) && stackAbility.isTriggeredAbility() && source.getControllerId().equals(eventSourceControllerId);
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

