/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TheMeepEffect
extends OneShotEffect {
    TheMeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature. If you do, creatures you control have base power and toughness X/X until end of turn, where X is the sacrificed creature's mana value";
    }

    private TheMeepEffect(TheMeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMeepEffect copy() {
        return new TheMeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(this.outcome, "Sacrifice another creature?", source, game) && cost.pay(source, game, source, source.getControllerId(), true))) {
            return false;
        }
        int xValue = cost.getPermanents().stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessAllEffect(xValue, xValue, Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE), source);
        return true;
    }
}

