/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class TheMindskinnerEffect
extends PreventionEffectImpl {
    TheMindskinnerEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "if a source you control would deal damage to an opponent, prevent that damage and each opponent mills that many cards.";
    }

    private TheMindskinnerEffect(TheMindskinnerEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public TheMindskinnerEffect copy() {
        return new TheMindskinnerEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amount = event.getAmount();
        this.preventDamageAction(event, source, game);
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.millCards(amount, source, game);
        }
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && source.isControlledBy(game.getControllerId(event.getSourceId())) && game.getOpponents(game.getControllerId(event.getSourceId())).contains(event.getTargetId());
    }
}

