/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.PhyrexianToken;
import mage.util.CardUtil;

class ThePhasingOfZhalfirDestroyEffect
extends OneShotEffect {
    ThePhasingOfZhalfirDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy all creatures. For each creature destroyed this way, its controller creates a 2/2 black Phyrexian creature token";
    }

    private ThePhasingOfZhalfirDestroyEffect(ThePhasingOfZhalfirDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThePhasingOfZhalfirDestroyEffect copy() {
        return new ThePhasingOfZhalfirDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> playerMap = new HashMap<UUID, Integer>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
            if (!permanent.destroy(source, game, false)) continue;
            playerMap.compute(permanent.getControllerId(), CardUtil::setOrIncrementValue);
        }
        game.processAction();
        PhyrexianToken token = new PhyrexianToken();
        for (Map.Entry entry : playerMap.entrySet()) {
            token.putOntoBattlefield(((Integer)entry.getValue()).intValue(), game, source, (UUID)entry.getKey());
        }
        return true;
    }
}

