/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class TheScorpionGodTriggeredAbility
extends TriggeredAbilityImpl {
    public TheScorpionGodTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private TheScorpionGodTriggeredAbility(TheScorpionGodTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TheScorpionGodTriggeredAbility copy() {
        return new TheScorpionGodTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && (permanent = game.getPermanentOrLKIBattlefield(zEvent.getTargetId())) != null && permanent.isCreature(game) && permanent.getCounters(game).containsKey(CounterType.M1M1);
    }

    public String getRule() {
        return "Whenever a creature with a -1/-1 counter on it dies, draw a card.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

