/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheSecondDoctorCantAttackEffect
extends RestrictionEffect {
    private final UUID opponentId;

    public TheSecondDoctorCantAttackEffect(UUID opponentId) {
        super(Duration.UntilEndOfYourNextTurn);
        this.opponentId = opponentId;
        this.staticText = "";
    }

    private TheSecondDoctorCantAttackEffect(TheSecondDoctorCantAttackEffect effect) {
        super((RestrictionEffect)effect);
        this.opponentId = effect.opponentId;
    }

    public TheSecondDoctorCantAttackEffect copy() {
        return new TheSecondDoctorCantAttackEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.opponentId != null) {
            this.setStartingControllerAndTurnNum(game, this.opponentId, game.getActivePlayerId());
        } else {
            this.discard();
        }
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return game.isActivePlayer(this.opponentId);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        UUID controllerId = source.getControllerId();
        if (defenderId == null) {
            return true;
        }
        Permanent defender = game.getPermanent(defenderId);
        if (defender != null) {
            return !defender.isControlledBy(controllerId);
        }
        return !defenderId.equals(controllerId);
    }
}

