/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TheSoundOfDrumsEffect
extends ReplacementEffectImpl {
    TheSoundOfDrumsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If enchanted creature would deal combat damage to a permanent or player, it deals double that damage instead";
    }

    private TheSoundOfDrumsEffect(TheSoundOfDrumsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheSoundOfDrumsEffect copy() {
        return new TheSoundOfDrumsEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && ((DamageEvent)event).isCombatDamage() && enchantment.isAttachedTo(event.getSourceId());
    }
}

