/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TheTemporalAnchorExileEffect
extends OneShotEffect {
    TheTemporalAnchorExileEffect() {
        super(Outcome.Benefit);
    }

    private TheTemporalAnchorExileEffect(TheTemporalAnchorExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheTemporalAnchorExileEffect copy() {
        return new TheTemporalAnchorExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int amount = (Integer)this.getValue("amount");
        if (player == null || amount < 1) {
            return false;
        }
        int toSkip = Math.max(player.getLibrary().size() - amount, 0);
        Set cards = player.getLibrary().getCards(game).stream().skip(toSkip).collect(Collectors.toSet());
        return !cards.isEmpty() && player.moveCardsToExile(cards, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

