/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class TheThreeSeasonsEffect
extends OneShotEffect {
    TheThreeSeasonsEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose three cards in each graveyard. Their owners shuffle those cards into their libraries";
    }

    private TheThreeSeasonsEffect(TheThreeSeasonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheThreeSeasonsEffect copy() {
        return new TheThreeSeasonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashMap<Player, CardsImpl> playerCardsMap = new LinkedHashMap<Player, CardsImpl>();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            int cardCount;
            Player player = game.getPlayer(playerId);
            if (player == null || (cardCount = Math.min(player.getGraveyard().size(), 3)) < 1) continue;
            TargetCardInGraveyard target = new TargetCardInGraveyard(cardCount, StaticFilters.FILTER_CARD);
            target.withNotTarget(true);
            controller.chooseTarget(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
            playerCardsMap.put(player, new CardsImpl((Collection)target.getTargets()));
        }
        for (Map.Entry entry : playerCardsMap.entrySet()) {
            ((Player)entry.getKey()).shuffleCardsToLibrary((Cards)entry.getValue(), game, source);
        }
        return true;
    }
}

