/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class TheTricksterGodsHeistTarget
extends TargetPermanent {
    private static final FilterPermanent filter = new FilterPermanent("nonbasic, noncreature permanents that share a card type");

    TheTricksterGodsHeistTarget() {
        super(2, 2, filter, false);
    }

    private TheTricksterGodsHeistTarget(TheTricksterGodsHeistTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        Permanent targetOne = game.getPermanent((UUID)this.getTargets().get(0));
        Permanent targetTwo = game.getPermanent(id);
        if (targetOne == null || targetTwo == null) {
            return false;
        }
        return targetOne.shareTypes((Card)targetTwo, game);
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        HashSet cardTypes = new HashSet();
        MageObject targetSource = game.getObject(source);
        if (targetSource == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, sourceControllerId, source, game)) {
            if (!this.isNotTarget() && !permanent.canBeTargetedBy(targetSource, sourceControllerId, source, game)) continue;
            for (CardType cardType : permanent.getCardType(game)) {
                if (!cardTypes.contains(cardType)) continue;
                return true;
            }
            cardTypes.addAll(permanent.getCardType(game));
        }
        return false;
    }

    public TheTricksterGodsHeistTarget copy() {
        return new TheTricksterGodsHeistTarget(this);
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

