/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TheTrueScripturesEffect
extends OneShotEffect {
    TheTrueScripturesEffect() {
        super(Outcome.Benefit);
        this.staticText = "put all creature cards from all graveyards onto the battlefield under your control";
    }

    private TheTrueScripturesEffect(TheTrueScripturesEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheTrueScripturesEffect copy() {
        return new TheTrueScripturesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(gy -> gy.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)).flatMap(Collection::stream).collect(Collectors.toList()));
        return player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }
}

