/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DemonstrateAbility;
import mage.cards.t.FirstSpellCastFromNotHandEachTurnCondition;
import mage.cards.t.TheTwelfthDoctorWatcher;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class TheTwelfthDoctorGainDemonstrateEffect
extends ContinuousEffectImpl {
    TheTwelfthDoctorGainDemonstrateEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "The first spell you cast from anywhere other than your hand each turn has demonstrate";
    }

    private TheTwelfthDoctorGainDemonstrateEffect(TheTwelfthDoctorGainDemonstrateEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheTwelfthDoctorGainDemonstrateEffect copy() {
        return new TheTwelfthDoctorGainDemonstrateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        TheTwelfthDoctorWatcher watcher = (TheTwelfthDoctorWatcher)game.getState().getWatcher(TheTwelfthDoctorWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId())) continue;
            Spell spell = (Spell)stackObject;
            if (!FirstSpellCastFromNotHandEachTurnCondition.instance.apply(game, source)) continue;
            game.getState().addOtherAbility(spell.getCard(), (Ability)new DemonstrateAbility());
        }
        return true;
    }
}

