/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheUrDragonTriggeredAbility
extends TriggeredAbilityImpl {
    public TheUrDragonTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private TheUrDragonTriggeredAbility(TheUrDragonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TheUrDragonTriggeredAbility copy() {
        return new TheUrDragonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int attackingDragons = 0;
        for (UUID attacker : game.getCombat().getAttackers()) {
            Permanent creature = game.getPermanent(attacker);
            if (creature == null || creature.getControllerId() == null || !creature.isControlledBy(this.getControllerId()) || !creature.hasSubtype(SubType.DRAGON, game)) continue;
            ++attackingDragons;
        }
        if (attackingDragons > 0) {
            this.getEffects().clear();
            this.addEffect((Effect)new DrawCardSourceControllerEffect(attackingDragons));
            this.addEffect((Effect)new PutCardFromHandOntoBattlefieldEffect());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more Dragons you control attack, draw that many cards, then you may put a permanent card from your hand onto the battlefield.";
    }
}

