/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class TheWaterCrystalEffect
extends ReplacementEffectImpl {
    TheWaterCrystalEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "if an opponent would mill one or more cards, they mill that many cards plus four instead";
    }

    private TheWaterCrystalEffect(TheWaterCrystalEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TheWaterCrystalEffect copy() {
        return new TheWaterCrystalEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MILL_CARDS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getOpponents(source.getControllerId()).contains(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)4));
        return false;
    }
}

