/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ThermokarstEffect
extends OneShotEffect {
    ThermokarstEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target land. If that land was a snow land, you gain 1 life.";
    }

    private ThermokarstEffect(ThermokarstEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThermokarstEffect copy() {
        return new ThermokarstEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && controller != null) {
            permanent.destroy(source, game, false);
            if (permanent.isSnow(game)) {
                controller.gainLife(1, game, source);
            }
            return true;
        }
        return false;
    }
}

