/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ThirstingAxeWatcher
extends Watcher {
    private final Set<MageObjectReference> dealtCombatDamageToCreature = new HashSet<MageObjectReference>();

    public ThirstingAxeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT || !((DamagedEvent)event).isCombatDamage()) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game)) {
            this.dealtCombatDamageToCreature.add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.dealtCombatDamageToCreature.clear();
    }

    static boolean checkCreature(UUID permanentId, Game game) {
        return ((ThirstingAxeWatcher)game.getState().getWatcher(ThirstingAxeWatcher.class)).dealtCombatDamageToCreature.stream().anyMatch(mor -> mor.refersTo(permanentId, game));
    }
}

