/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class ThoughtDistortionEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterNonlandCard();

    ThoughtDistortionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. Exile all noncreature, nonland cards from that player's hand and graveyard.";
    }

    private ThoughtDistortionEffect(ThoughtDistortionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtDistortionEffect copy() {
        return new ThoughtDistortionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        CardsImpl cards = new CardsImpl(player.getHand().getCards(filter, game));
        cards.addAllCards((Collection)player.getGraveyard().getCards(filter, game));
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

