/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.t.OnePlayerHasTheMostWizards;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThoughtboundPrimocEffect
extends OneShotEffect {
    ThoughtboundPrimocEffect() {
        super(Outcome.GainControl);
        this.staticText = "the player who controls the most Wizards gains control of {this}";
    }

    private ThoughtboundPrimocEffect(ThoughtboundPrimocEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThoughtboundPrimocEffect copy() {
        return new ThoughtboundPrimocEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) {
            return false;
        }
        Player newController = OnePlayerHasTheMostWizards.getPlayerWithMostWizards(game, source);
        if (newController != null) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, newController.getId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            if (!source.isControlledBy(newController.getId())) {
                game.informPlayers(newController.getLogName() + " got control of " + sourcePermanent.getLogName());
            }
        }
        return true;
    }
}

