/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class ThousandFacedShadowTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterAttackingCreature("another attacking creature");

    ThousandFacedShadowTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenCopyTargetEffect(null, null, false, 1, true, true));
        this.addTarget((Target)new TargetPermanent(filter));
    }

    private ThousandFacedShadowTriggeredAbility(ThousandFacedShadowTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ThousandFacedShadowTriggeredAbility copy() {
        return new ThousandFacedShadowTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && ((EntersTheBattlefieldEvent)event).getFromZone() == Zone.HAND && permanent.getId().equals(this.getSourceId());
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        return permanent != null && permanent.isAttacking();
    }

    public String getRule() {
        return "When {this} enters from your hand, if it's attacking, create a token that's a copy of another target attacking creature. The token enters tapped and attacking.";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

