/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ThrasiosTritonHeroEffect
extends OneShotEffect {
    ThrasiosTritonHeroEffect() {
        super(Outcome.DrawCard);
        this.staticText = "scry 1, then reveal the top card of your library. If it's a land card, put it onto the battlefield tapped. Otherwise, draw a card";
    }

    private ThrasiosTritonHeroEffect(ThrasiosTritonHeroEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThrasiosTritonHeroEffect copy() {
        return new ThrasiosTritonHeroEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.scry(1, source, game);
        if (!controller.getLibrary().hasCards()) {
            return true;
        }
        CardsImpl cards = new CardsImpl();
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        cards.add(card);
        controller.revealCards(source, (Cards)cards, game);
        if (card.isLand(game)) {
            return controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        controller.drawCards(1, source, game);
        return true;
    }
}

